<?php
// معالجة إضافة حجز جديد
$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_booking'])) {
    $customer_name = $_POST['customer_name'] ?? '';
    $customer_email = $_POST['customer_email'] ?? '';
    $customer_phone = $_POST['customer_phone'] ?? '';
    $car_id = $_POST['car_id'] ?? '';
    $start_date = $_POST['start_date'] ?? '';
    $end_date = $_POST['end_date'] ?? '';
    
    if (!empty($customer_name) && !empty($customer_email) && !empty($car_id) && !empty($start_date) && !empty($end_date)) {
        // حساب السعر الإجمالي
        $car_result = $conn->query("SELECT price_per_day FROM cars WHERE id = $car_id");
        $car_data = $car_result->fetch_assoc();
        $price_per_day = $car_data['price_per_day'];
        
        $days = (strtotime($end_date) - strtotime($start_date)) / (60 * 60 * 24);
        $total_price = $price_per_day * $days;
        
        $stmt = $conn->prepare("INSERT INTO bookings (customer_name, customer_email, customer_phone, car_id, start_date, end_date, total_price) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sssissd", $customer_name, $customer_email, $customer_phone, $car_id, $start_date, $end_date, $total_price);
        
        if ($stmt->execute()) {
            $success = "تم إضافة الحجز بنجاح!";
        } else {
            $error = "حدث خطأ أثناء إضافة الحجز";
        }
        $stmt->close();
    } else {
        $error = "يرجى ملء جميع الحقول المطلوبة";
    }
}

// حذف حجز
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $booking_id = $_GET['delete'];
    $conn->query("DELETE FROM bookings WHERE id = $booking_id");
    header("Location: ?page=bookings&msg=deleted");
    exit();
}

// الحصول على جميع الحجوزات
$bookings = $conn->query("SELECT b.*, c.brand, c.model FROM bookings b LEFT JOIN cars c ON b.car_id = c.id ORDER BY b.created_at DESC");

// الحصول على السيارات المتاحة للحجز
$available_cars = $conn->query("SELECT id, brand, model FROM cars WHERE status = 'available'");
?>

<?php if ($success): ?>
    <div class="success-message"><?php echo $success; ?></div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="error-message"><?php echo $error; ?></div>
<?php endif; ?>

<?php if (isset($_GET['msg']) && $_GET['msg'] == 'deleted'): ?>
    <div class="success-message">تم حذف الحجز بنجاح</div>
<?php endif; ?>

<!-- نموذج إضافة حجز جديد -->
<div class="table-container" style="margin-bottom: 30px;">
    <h2 style="margin-bottom: 20px; color: #2c3e50;">إضافة حجز جديد</h2>
    <form method="POST" action="">
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
            <div class="form-group">
                <label for="customer_name">اسم العميل *</label>
                <input type="text" id="customer_name" name="customer_name" required>
            </div>
            
            <div class="form-group">
                <label for="customer_email">البريد الإلكتروني *</label>
                <input type="email" id="customer_email" name="customer_email" required>
            </div>
            
            <div class="form-group">
                <label for="customer_phone">رقم الهاتف</label>
                <input type="tel" id="customer_phone" name="customer_phone">
            </div>
            
            <div class="form-group">
                <label for="car_id">السيارة *</label>
                <select id="car_id" name="car_id" required>
                    <option value="">اختر السيارة</option>
                    <?php while($car = $available_cars->fetch_assoc()): ?>
                        <option value="<?php echo $car['id']; ?>">
                            <?php echo htmlspecialchars($car['brand'] . ' ' . $car['model']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <div class="form-group">
                <label for="start_date">تاريخ البداية *</label>
                <input type="date" id="start_date" name="start_date" required>
            </div>
            
            <div class="form-group">
                <label for="end_date">تاريخ النهاية *</label>
                <input type="date" id="end_date" name="end_date" required>
            </div>
        </div>
        
        <button type="submit" name="add_booking" class="btn btn-primary">حفظ الحجز</button>
    </form>
</div>

<!-- قائمة الحجوزات -->
<div class="table-container">
    <h2 style="margin-bottom: 20px; color: #2c3e50;">قائمة الحجوزات</h2>
    <table>
        <thead>
            <tr>
                <th>رقم الحجز</th>
                <th>اسم العميل</th>
                <th>البريد الإلكتروني</th>
                <th>الهاتف</th>
                <th>السيارة</th>
                <th>تاريخ البداية</th>
                <th>تاريخ النهاية</th>
                <th>السعر الإجمالي</th>
                <th>الحالة</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($bookings->num_rows > 0): ?>
                <?php while($booking = $bookings->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $booking['id']; ?></td>
                        <td><?php echo htmlspecialchars($booking['customer_name']); ?></td>
                        <td><?php echo htmlspecialchars($booking['customer_email']); ?></td>
                        <td><?php echo htmlspecialchars($booking['customer_phone']); ?></td>
                        <td><?php echo htmlspecialchars($booking['brand'] . ' ' . $booking['model']); ?></td>
                        <td><?php echo date('Y-m-d', strtotime($booking['start_date'])); ?></td>
                        <td><?php echo date('Y-m-d', strtotime($booking['end_date'])); ?></td>
                        <td><?php echo number_format($booking['total_price'], 2); ?> ريال</td>
                        <td>
                            <?php 
                            $status_ar = [
                                'pending' => '⏳ معلق',
                                'confirmed' => '✅ مؤكد',
                                'cancelled' => '❌ ملغي'
                            ];
                            echo $status_ar[$booking['status']];
                            ?>
                        </td>
                        <td>
                            <a href="?page=bookings&delete=<?php echo $booking['id']; ?>" 
                               onclick="return confirm('هل أنت متأكد من حذف هذا الحجز؟')" 
                               class="btn btn-danger btn-small">حذف</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="10" style="text-align: center;">لا توجد حجوزات</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>